Macro "Zero to Null"
    // This macro finds values of zero in numeric fields and changes them
    // to null. The macro illustrates how to:
    // 1. Read all of the records in a dataview.
    // 2. Get values for some or all of the fields in a record.
    // 3. Check and change values in fields.
    // 4. Write updated values back to fields.

    // You can read just the records in a selection set and/or visit the
    // records in sort order using different values for the arguments for
    // GetFirstRecord() and GetNextRecord(). You can choose which fields
    // to read or write by building fields_arrays and values_array in
    // different ways. You can fill fields based on the results of
    // expressions. Consider this macro to be a shell that you can adapt
    // to many different tasks.

    // To run this macro using the Maptitude GISDK toolbox:
    // 1. Open or make current the dataview that you want to modify by changing
    //    all zero values to null.
    // 2. Choose Tools-Add-Ins and open the GIS Developer's Kit toolbox.
    // 3. Compile this macro in test mode using the first button (Compile).
    // 4. Run this macro by clicking the second button (Test), typing the macro 
    //    name "Zero to Null", and clicking OK. The type of add-in is macro
    //   (the default).

    // Get current dataview
    view = GetView()
    view_set = view + "|"

    // Get list of numeric fields in dataview
    fields_arrays = GetFields(view, "Numeric")
    num_fields = ArrayLength(fields_arrays[1])

    // Loop over the records
    rec = GetFirstRecord(view_set, )
    while rec <> null do

        // Read all the numeric fields and their values
        values_array = GetRecordValues(view, rec, fields_arrays[1])

        // Change zero values to null
        for i = 1 to num_fields do
            if values_array[i][2] = 0 then values_array[i][2] = null
            end

        // Write all the numeric fields with their new values
        SetRecordValues(view, rec, values_array)

        // Get next record
        rec = GetNextRecord(view_set, rec, )
        end

endMacro
